<?php

const CACHE_BUSINESS_SETTINGS_TABLE = 'cache_business_settings_table';
const CACHE_LOGIN_SETUP_TABLE = 'cache_login_setup_table';
const CACHE_BANNER_TABLE = 'cache_banner_table';
const CACHE_CATEGORY_TABLE = 'cache_category_table';

const TELEPHONE_CODES = [
    ["name" => 'UK (+44)', "code" => '44'],
    ["name" => 'USA (+1)', "code" => '1'],
    ["name" => 'Algeria (+213)', "code" => '213'],
    ["name" => 'Andorra (+376)', "code" => '376'],
    ["name" => 'Angola (+244)', "code" => '244'],
    ["name" => 'Anguilla (+1264)', "code" => '1264'],
    ["name" => 'Antigua & Barbuda (+1268)', "code" => '1268'],
    ["name" => 'Argentina (+54)', "code" => '54'],
    ["name" => 'Armenia (+374)', "code" => '374'],
    ["name" => 'Aruba (+297)', "code" => '297'],
    ["name" => 'Australia (+61)', "code" => '61'],
    ["name" => 'Austria (+43)', "code" => '43'],
    ["name" => 'Azerbaijan (+994)', "code" => '994'],
    ["name" => 'Bahamas (+1242)', "code" => '1242'],
    ["name" => 'Bahrain (+973)', "code" => '973'],
    ["name" => 'Bangladesh (+880)', "code" => '880'],
    ["name" => 'Barbados (+1246)', "code" => '1246'],
    ["name" => 'Belarus (+375)', "code" => '375'],
    ["name" => 'Belgium (+32)', "code" => '32'],
    ["name" => 'Belize (+501)', "code" => '501'],
    ["name" => 'Benin (+229)', "code" => '229'],
    ["name" => 'Bermuda (+1441)', "code" => '1441'],
    ["name" => 'Bhutan (+975)', "code" => '975'],
    ["name" => 'Bolivia (+591)', "code" => '591'],
    ["name" => 'Bosnia Herzegovina (+387)', "code" => '387'],
    ["name" => 'Botswana (+267)', "code" => '267'],
    ["name" => 'Brazil (+55)', "code" => '55'],
    ["name" => 'Brunei (+673)', "code" => '673'],
    ["name" => 'Bulgaria (+359)', "code" => '359'],
    ["name" => 'Burkina Faso (+226)', "code" => '226'],
    ["name" => 'Burundi (+257)', "code" => '257'],
    ["name" => 'Cambodia (+855)', "code" => '855'],
    ["name" => 'Cameroon (+237)', "code" => '237'],
    ["name" => 'Canada (+1)', "code" => '1'],
    ["name" => 'Cape Verde Islands (+238)', "code" => '238'],
    ["name" => 'Cayman Islands (+1345)', "code" => '1345'],
    ["name" => 'Central African Republic (+236)', "code" => '236'],
    ["name" => 'Chile (+56)', "code" => '56'],
    ["name" => 'China (+86)', "code" => '86'],
    ["name" => 'Colombia (+57)', "code" => '57'],
    ["name" => 'Comoros (+269)', "code" => '269'],
    ["name" => 'Congo (+242)', "code" => '242'],
    ["name" => 'Cook Islands (+682)', "code" => '682'],
    ["name" => 'Costa Rica (+506)', "code" => '506'],
    ["name" => 'Croatia (+385)', "code" => '385'],
    ["name" => 'Cuba (+53)', "code" => '53'],
    ["name" => 'Cyprus North (+90392)', "code" => '90392'],
    ["name" => 'Cyprus South (+357)', "code" => '357'],
    ["name" => 'Czech Republic (+42)', "code" => '42'],
    ["name" => 'Denmark (+45)', "code" => '45'],
    ["name" => 'Djibouti (+253)', "code" => '253'],
    ["name" => 'Dominica (+1767)', "code" => '1767'],
    ["name" => 'Dominican Republic (+1809)', "code" => '1809'],
    ["name" => 'Ecuador (+593)', "code" => '593'],
    ["name" => 'Egypt (+20)', "code" => '20'],
    ["name" => 'El Salvador (+503)', "code" => '503'],
    ["name" => 'Equatorial Guinea (+240)', "code" => '240'],
    ["name" => 'Eritrea (+291)', "code" => '291'],
    ["name" => 'Estonia (+372)', "code" => '372'],
    ["name" => 'Ethiopia (+251)', "code" => '251'],
    ["name" => 'Falkland Islands (+500)', "code" => '500'],
    ["name" => 'Faroe Islands (+298)', "code" => '298'],
    ["name" => 'Fiji (+679)', "code" => '679'],
    ["name" => 'Finland (+358)', "code" => '358'],
    ["name" => 'France (+33)', "code" => '33'],
    ["name" => 'French Guiana (+594)', "code" => '594'],
    ["name" => 'French Polynesia (+689)', "code" => '689'],
    ["name" => 'Gabon (+241)', "code" => '241'],
    ["name" => 'Gambia (+220)', "code" => '220'],
    ["name" => 'Georgia (+7880)', "code" => '7880'],
    ["name" => 'Germany (+49)', "code" => '49'],
    ["name" => 'Ghana (+233)', "code" => '233'],
    ["name" => 'Gibraltar (+350)', "code" => '350'],
    ["name" => 'Greece (+30)', "code" => '30'],
    ["name" => 'Greenland (+299)', "code" => '299'],
    ["name" => 'Grenada (+1473)', "code" => '1473'],
    ["name" => 'Guadeloupe (+590)', "code" => '590'],
    ["name" => 'Guam (+671)', "code" => '671'],
    ["name" => 'Guatemala (+502)', "code" => '502'],
    ["name" => 'Guinea (+224)', "code" => '224'],
    ["name" => 'Guinea - Bissau (+245)', "code" => '245'],
    ["name" => 'Guyana (+592)', "code" => '592'],
    ["name" => 'Haiti (+509)', "code" => '509'],
    ["name" => 'Honduras (+504)', "code" => '504'],
    ["name" => 'Hong Kong (+852)', "code" => '852'],
    ["name" => 'Hungary (+36)', "code" => '36'],
    ["name" => 'Iceland (+354)', "code" => '354'],
    ["name" => 'India (+91)', "code" => '91'],
    ["name" => 'Indonesia (+62)', "code" => '62'],
    ["name" => 'Iran (+98)', "code" => '98'],
    ["name" => 'Iraq (+964)', "code" => '964'],
    ["name" => 'Ireland (+353)', "code" => '353'],
    ["name" => 'Israel (+972)', "code" => '972'],
    ["name" => 'Italy (+39)', "code" => '39'],
    ["name" => 'Jamaica (+1876)', "code" => '1876'],
    ["name" => 'Japan (+81)', "code" => '81'],
    ["name" => 'Jordan (+962)', "code" => '962'],
    ["name" => 'Kazakhstan (+7)', "code" => '7'],
    ["name" => 'Kenya (+254)', "code" => '254'],
    ["name" => 'Kiribati (+686)', "code" => '686'],
    ["name" => 'Korea North (+850)', "code" => '850'],
    ["name" => 'Korea South (+82)', "code" => '82'],
    ["name" => 'Kuwait (+965)', "code" => '965'],
    ["name" => 'Kyrgyzstan (+996)', "code" => '996'],
    ["name" => 'Laos (+856)', "code" => '856'],
    ["name" => 'Latvia (+371)', "code" => '371'],
    ["name" => 'Lebanon (+961)', "code" => '961'],
    ["name" => 'Lesotho (+266)', "code" => '266'],
    ["name" => 'Liberia (+231)', "code" => '231'],
    ["name" => 'Libya (+218)', "code" => '218'],
    ["name" => 'Liechtenstein (+417)', "code" => '417'],
    ["name" => 'Lithuania (+370)', "code" => '370'],
    ["name" => 'Luxembourg (+352)', "code" => '352'],
    ["name" => 'Macao (+853)', "code" => '853'],
    ["name" => 'Macedonia (+389)', "code" => '389'],
    ["name" => 'Madagascar (+261)', "code" => '261'],
    ["name" => 'Malawi (+265)', "code" => '265'],
    ["name" => 'Malaysia (+60)', "code" => '60'],
    ["name" => 'Maldives (+960)', "code" => '960'],
    ["name" => 'Mali (+223)', "code" => '223'],
    ["name" => 'Malta (+356)', "code" => '356'],
    ["name" => 'Marshall Islands (+692)', "code" => '692'],
    ["name" => 'Martinique (+596)', "code" => '596'],
    ["name" => 'Mauritania (+222)', "code" => '222'],
    ["name" => 'Mayotte (+269)', "code" => '269'],
    ["name" => 'Mexico (+52)', "code" => '52'],
    ["name" => 'Micronesia (+691)', "code" => '691'],
    ["name" => 'Moldova (+373)', "code" => '373'],
    ["name" => 'Monaco (+377)', "code" => '377'],
    ["name" => 'Montserrat (+1664)', "code" => '1664'],
    ["name" => 'Morocco (+212)', "code" => '212'],
    ["name" => 'Mozambique (+258)', "code" => '258'],
    ["name" => 'Myanmar (+95)', "code" => '95'],
    ["name" => 'Namibia (+264)', "code" => '264'],
    ["name" => 'Nauru (+674)', "code" => '674'],
    ["name" => 'Nepal (+977)', "code" => '977'],
    ["name" => 'Netherlands (+31)', "code" => '31'],
    ["name" => 'New Caledonia (+687)', "code" => '687'],
    ["name" => 'New Zealand (+64)', "code" => '64'],
    ["name" => 'Nicaragua (+505)', "code" => '505'],
    ["name" => 'Niger (+227)', "code" => '227'],
    ["name" => 'Nigeria (+234)', "code" => '234'],
    ["name" => 'Niue (+683)', "code" => '683'],
    ["name" => 'Norfolk Islands (+672)', "code" => '672'],
    ["name" => 'Northern Marianas (+670)', "code" => '670'],
    ["name" => 'Norway (+47)', "code" => '47'],
    ["name" => 'Oman (+968)', "code" => '968'],
    ["name" => 'Pakistan (+92)', "code" => '92'],
    ["name" => 'Palau (+680)', "code" => '680'],
    ["name" => 'Panama (+507)', "code" => '507'],
    ["name" => 'Papua New Guinea (+675)', "code" => '675'],
    ["name" => 'Paraguay (+595)', "code" => '595'],
    ["name" => 'Peru (+51)', "code" => '51'],
    ["name" => 'Philippines (+63)', "code" => '63'],
    ["name" => 'Poland (+48)', "code" => '48'],
    ["name" => 'Portugal (+351)', "code" => '351'],
    ["name" => 'Qatar (+974)', "code" => '974'],
    ["name" => 'Reunion (+262)', "code" => '262'],
    ["name" => 'Romania (+40)', "code" => '40'],
    ["name" => 'Russia (+7)', "code" => '7'],
    ["name" => 'Rwanda (+250)', "code" => '250'],
    ["name" => 'San Marino (+378)', "code" => '378'],
    ["name" => 'Sao Tome & Principe (+239)', "code" => '239'],
    ["name" => 'Saudi Arabia (+966)', "code" => '966'],
    ["name" => 'Senegal (+221)', "code" => '221'],
    ["name" => 'Serbia (+381)', "code" => '381'],
    ["name" => 'Seychelles (+248)', "code" => '248'],
    ["name" => 'Sierra Leone (+232)', "code" => '232'],
    ["name" => 'Singapore (+65)', "code" => '65'],
    ["name" => 'Slovak Republic (+421)', "code" => '421'],
    ["name" => 'Slovenia (+386)', "code" => '386'],
    ["name" => 'Solomon Islands (+677)', "code" => '677'],
    ["name" => 'Somalia (+252)', "code" => '252'],
    ["name" => 'South Africa (+27)', "code" => '27'],
    ["name" => 'Spain (+34)', "code" => '34'],
    ["name" => 'Sri Lanka (+94)', "code" => '94'],
    ["name" => 'St. Helena (+290)', "code" => '290'],
    ["name" => 'St. Kitts (+1869)', "code" => '1869'],
    ["name" => 'St. Lucia (+1758)', "code" => '1758'],
    ["name" => 'Sudan (+249)', "code" => '249'],
    ["name" => 'Suriname (+597)', "code" => '597'],
    ["name" => 'Swaziland (+268)', "code" => '268'],
    ["name" => 'Sweden (+46)', "code" => '46'],
    ["name" => 'Switzerland (+41)', "code" => '41'],
    ["name" => 'Syria (+963)', "code" => '963'],
    ["name" => 'Taiwan (+886)', "code" => '886'],
    ["name" => 'Tajikstan (+7)', "code" => '7'],
    ["name" => 'Thailand (+66)', "code" => '66'],
    ["name" => 'Togo (+228)', "code" => '228'],
    ["name" => 'Tonga (+676)', "code" => '676'],
    ["name" => 'Trinidad & Tobago (+1868)', "code" => '1868'],
    ["name" => 'Tunisia (+216)', "code" => '216'],
    ["name" => 'Turkey (+90)', "code" => '90'],
    ["name" => 'Turkmenistan (+7)', "code" => '7'],
    ["name" => 'Turkmenistan (+993)', "code" => '993'],
    ["name" => 'Turks & Caicos Islands (+1649)', "code" => '1649'],
    ["name" => 'Tuvalu (+688)', "code" => '688'],
    ["name" => 'Uganda (+256)', "code" => '256'],
    ["name" => 'Ukraine (+380)', "code" => '380'],
    ["name" => 'United Arab Emirates (+971)', "code" => '971'],
    ["name" => 'Uruguay (+598)', "code" => '598'],
    ["name" => 'Uzbekistan (+7)', "code" => '7'],
    ["name" => 'Vanuatu (+678)', "code" => '678'],
    ["name" => 'Vatican City (+379)', "code" => '379'],
    ["name" => 'Venezuela (+58)', "code" => '58'],
    ["name" => 'Vietnam (+84)', "code" => '84'],
    ["name" => 'Virgin Islands - British (+1284)', "code" => '1284'],
    ["name" => 'Virgin Islands - US (+1340)', "code" => '1340'],
    ["name" => 'Wallis & Futuna (+681)', "code" => '681'],
    ["name" => 'Yemen (North)(+969)', "code" => '969'],
    ["name" => 'Yemen (South)(+967)', "code" => '967'],
    ["name" => 'Zambia (+260)', "code" => '260'],
    ["name" => 'Zimbabwe (+263)', "code" => '263'],
];

const COUNTRY_CODE = [
    ['code' => 'AF', 'name' => 'Afghanistan'],
    ['code' => 'AX', 'name' => 'Åland Islands'],
    ['code' => 'AL', 'name' => 'Albania'],
    ['code' => 'DZ', 'name' => 'Algeria'],
    ['code' => 'AS', 'name' => 'American Samoa'],
    ['code' => 'AD', 'name' => 'Andorra'],
    ['code' => 'AO', 'name' => 'Angola'],
    ['code' => 'AI', 'name' => 'Anguilla'],
    ['code' => 'AQ', 'name' => 'Antarctica'],
    ['code' => 'AG', 'name' => 'Antigua and Barbuda'],
    ['code' => 'AR', 'name' => 'Argentina'],
    ['code' => 'AM', 'name' => 'Armenia'],
    ['code' => 'AW', 'name' => 'Aruba'],
    ['code' => 'AU', 'name' => 'Australia'],
    ['code' => 'AT', 'name' => 'Austria'],
    ['code' => 'AZ', 'name' => 'Azerbaijan'],
    ['code' => 'BS', 'name' => 'Bahamas'],
    ['code' => 'BH', 'name' => 'Bahrain'],
    ['code' => 'BD', 'name' => 'Bangladesh'],
    ['code' => 'BB', 'name' => 'Barbados'],
    ['code' => 'BY', 'name' => 'Belarus'],
    ['code' => 'BE', 'name' => 'Belgium'],
    ['code' => 'BZ', 'name' => 'Belize'],
    ['code' => 'BJ', 'name' => 'Benin'],
    ['code' => 'BM', 'name' => 'Bermuda'],
    ['code' => 'BT', 'name' => 'Bhutan'],
    ['code' => 'BO', 'name' => 'Bolivia, Plurinational State of'],
    ['code' => 'BQ', 'name' => 'Bonaire, Sint Eustatius and Saba'],
    ['code' => 'BA', 'name' => 'Bosnia and Herzegovina'],
    ['code' => 'BW', 'name' => 'Botswana'],
    ['code' => 'BV', 'name' => 'Bouvet Island'],
    ['code' => 'BR', 'name' => 'Brazil'],
    ['code' => 'IO', 'name' => 'British Indian Ocean Territory'],
    ['code' => 'BN', 'name' => 'Brunei Darussalam'],
    ['code' => 'BG', 'name' => 'Bulgaria'],
    ['code' => 'BF', 'name' => 'Burkina Faso'],
    ['code' => 'BI', 'name' => 'Burundi'],
    ['code' => 'KH', 'name' => 'Cambodia'],
    ['code' => 'CM', 'name' => 'Cameroon'],
    ['code' => 'CA', 'name' => 'Canada'],
    ['code' => 'CV', 'name' => 'Cape Verde'],
    ['code' => 'KY', 'name' => 'Cayman Islands'],
    ['code' => 'CF', 'name' => 'Central African Republic'],
    ['code' => 'TD', 'name' => 'Chad'],
    ['code' => 'CL', 'name' => 'Chile'],
    ['code' => 'CN', 'name' => 'China'],
    ['code' => 'CX', 'name' => 'Christmas Island'],
    ['code' => 'CC', 'name' => 'Cocos (Keeling) Islands'],
    ['code' => 'CO', 'name' => 'Colombia'],
    ['code' => 'KM', 'name' => 'Comoros'],
    ['code' => 'CG', 'name' => 'Congo'],
    ['code' => 'CD', 'name' => 'Congo, the Democratic Republic of the'],
    ['code' => 'CK', 'name' => 'Cook Islands'],
    ['code' => 'CR', 'name' => 'Costa Rica'],
    ['code' => 'CI', 'name' => 'Côte d\'Ivoire'],
    ['code' => 'HR', 'name' => 'Croatia'],
    ['code' => 'CU', 'name' => 'Cuba'],
    ['code' => 'CW', 'name' => 'Curaçao'],
    ['code' => 'CY', 'name' => 'Cyprus'],
    ['code' => 'CZ', 'name' => 'Czech Republic'],
    ['code' => 'DK', 'name' => 'Denmark'],
    ['code' => 'DJ', 'name' => 'Djibouti'],
    ['code' => 'DM', 'name' => 'Dominica'],
    ['code' => 'DO', 'name' => 'Dominican Republic'],
    ['code' => 'EC', 'name' => 'Ecuador'],
    ['code' => 'EG', 'name' => 'Egypt'],
    ['code' => 'SV', 'name' => 'El Salvador'],
    ['code' => 'GQ', 'name' => 'Equatorial Guinea'],
    ['code' => 'ER', 'name' => 'Eritrea'],
    ['code' => 'EE', 'name' => 'Estonia'],
    ['code' => 'ET', 'name' => 'Ethiopia'],
    ['code' => 'FK', 'name' => 'Falkland Islands (Malvinas)'],
    ['code' => 'FO', 'name' => 'Faroe Islands'],
    ['code' => 'FJ', 'name' => 'Fiji'],
    ['code' => 'FI', 'name' => 'Finland'],
    ['code' => 'FR', 'name' => 'France'],
    ['code' => 'GF', 'name' => 'French Guiana'],
    ['code' => 'PF', 'name' => 'French Polynesia'],
    ['code' => 'TF', 'name' => 'French Southern Territories'],
    ['code' => 'GA', 'name' => 'Gabon'],
    ['code' => 'GM', 'name' => 'Gambia'],
    ['code' => 'GE', 'name' => 'Georgia'],
    ['code' => 'DE', 'name' => 'Germany'],
    ['code' => 'GH', 'name' => 'Ghana'],
    ['code' => 'GI', 'name' => 'Gibraltar'],
    ['code' => 'GR', 'name' => 'Greece'],
    ['code' => 'GL', 'name' => 'Greenland'],
    ['code' => 'GD', 'name' => 'Grenada'],
    ['code' => 'GP', 'name' => 'Guadeloupe'],
    ['code' => 'GU', 'name' => 'Guam'],
    ['code' => 'GT', 'name' => 'Guatemala'],
    ['code' => 'GG', 'name' => 'Guernsey'],
    ['code' => 'GN', 'name' => 'Guinea'],
    ['code' => 'GW', 'name' => 'Guinea-Bissau'],
    ['code' => 'GY', 'name' => 'Guyana'],
    ['code' => 'HT', 'name' => 'Haiti'],
    ['code' => 'HM', 'name' => 'Heard Island and McDonald Islands'],
    ['code' => 'VA', 'name' => 'Holy See (Vatican City State)'],
    ['code' => 'HN', 'name' => 'Honduras'],
    ['code' => 'HK', 'name' => 'Hong Kong'],
    ['code' => 'HU', 'name' => 'Hungary'],
    ['code' => 'IS', 'name' => 'Iceland'],
    ['code' => 'IN', 'name' => 'India'],
    ['code' => 'ID', 'name' => 'Indonesia'],
    ['code' => 'IR', 'name' => 'Iran, Islamic Republic of'],
    ['code' => 'IQ', 'name' => 'Iraq'],
    ['code' => 'IE', 'name' => 'Ireland'],
    ['code' => 'IM', 'name' => 'Isle of Man'],
    ['code' => 'IL', 'name' => 'Israel'],
    ['code' => 'IT', 'name' => 'Italy'],
    ['code' => 'JM', 'name' => 'Jamaica'],
    ['code' => 'JP', 'name' => 'Japan'],
    ['code' => 'JE', 'name' => 'Jersey'],
    ['code' => 'JO', 'name' => 'Jordan'],
    ['code' => 'KZ', 'name' => 'Kazakhstan'],
    ['code' => 'KE', 'name' => 'Kenya'],
    ['code' => 'KI', 'name' => 'Kiribati'],
    ['code' => 'KP', 'name' => 'Korea, Democratic People\'s Republic of'],
    ['code' => 'KR', 'name' => 'Korea, Republic of'],
    ['code' => 'KW', 'name' => 'Kuwait'],
    ['code' => 'KG', 'name' => 'Kyrgyzstan'],
    ['code' => 'LA', 'name' => 'Lao People\'s Democratic Republic'],
    ['code' => 'LV', 'name' => 'Latvia'],
    ['code' => 'LB', 'name' => 'Lebanon'],
    ['code' => 'LS', 'name' => 'Lesotho'],
    ['code' => 'LR', 'name' => 'Liberia'],
    ['code' => 'LY', 'name' => 'Libya'],
    ['code' => 'LI', 'name' => 'Liechtenstein'],
    ['code' => 'LT', 'name' => 'Lithuania'],
    ['code' => 'LU', 'name' => 'Luxembourg'],
    ['code' => 'MO', 'name' => 'Macao'],
    ['code' => 'MK', 'name' => 'Macedonia, the former Yugoslav Republic of'],
    ['code' => 'MG', 'name' => 'Madagascar'],
    ['code' => 'MW', 'name' => 'Malawi'],
    ['code' => 'MY', 'name' => 'Malaysia'],
    ['code' => 'MV', 'name' => 'Maldives'],
    ['code' => 'ML', 'name' => 'Mali'],
    ['code' => 'MT', 'name' => 'Malta'],
    ['code' => 'MH', 'name' => 'Marshall Islands'],
    ['code' => 'MQ', 'name' => 'Martinique'],
    ['code' => 'MR', 'name' => 'Mauritania'],
    ['code' => 'MU', 'name' => 'Mauritius'],
    ['code' => 'YT', 'name' => 'Mayotte'],
    ['code' => 'MX', 'name' => 'Mexico'],
    ['code' => 'FM', 'name' => 'Micronesia, Federated States of'],
    ['code' => 'MD', 'name' => 'Moldova, Republic of'],
    ['code' => 'MC', 'name' => 'Monaco'],
    ['code' => 'MN', 'name' => 'Mongolia'],
    ['code' => 'ME', 'name' => 'Montenegro'],
    ['code' => 'MS', 'name' => 'Montserrat'],
    ['code' => 'MA', 'name' => 'Morocco'],
    ['code' => 'MZ', 'name' => 'Mozambique'],
    ['code' => 'MM', 'name' => 'Myanmar'],
    ['code' => 'NA', 'name' => 'Namibia'],
    ['code' => 'NR', 'name' => 'Nauru'],
    ['code' => 'NP', 'name' => 'Nepal'],
    ['code' => 'NL', 'name' => 'Netherlands'],
    ['code' => 'NC', 'name' => 'New Caledonia'],
    ['code' => 'NZ', 'name' => 'New Zealand'],
    ['code' => 'NI', 'name' => 'Nicaragua'],
    ['code' => 'NE', 'name' => 'Niger'],
    ['code' => 'NG', 'name' => 'Nigeria'],
    ['code' => 'NU', 'name' => 'Niue'],
    ['code' => 'NF', 'name' => 'Norfolk Island'],
    ['code' => 'MP', 'name' => 'Northern Mariana Islands'],
    ['code' => 'NO', 'name' => 'Norway'],
    ['code' => 'OM', 'name' => 'Oman'],
    ['code' => 'PK', 'name' => 'Pakistan'],
    ['code' => 'PW', 'name' => 'Palau'],
    ['code' => 'PS', 'name' => 'Palestinian Territory, Occupied'],
    ['code' => 'PA', 'name' => 'Panama'],
    ['code' => 'PG', 'name' => 'Papua New Guinea'],
    ['code' => 'PY', 'name' => 'Paraguay'],
    ['code' => 'PE', 'name' => 'Peru'],
    ['code' => 'PH', 'name' => 'Philippines'],
    ['code' => 'PN', 'name' => 'Pitcairn'],
    ['code' => 'PL', 'name' => 'Poland'],
    ['code' => 'PT', 'name' => 'Portugal'],
    ['code' => 'PR', 'name' => 'Puerto Rico'],
    ['code' => 'QA', 'name' => 'Qatar'],
    ['code' => 'RE', 'name' => 'Réunion'],
    ['code' => 'RO', 'name' => 'Romania'],
    ['code' => 'RU', 'name' => 'Russian Federation'],
    ['code' => 'RW', 'name' => 'Rwanda'],
    ['code' => 'BL', 'name' => 'Saint Barthélemy'],
    ['code' => 'SH', 'name' => 'Saint Helena, Ascension and Tristan da Cunha'],
    ['code' => 'KN', 'name' => 'Saint Kitts and Nevis'],
    ['code' => 'LC', 'name' => 'Saint Lucia'],
    ['code' => 'MF', 'name' => 'Saint Martin (French part)'],
    ['code' => 'PM', 'name' => 'Saint Pierre and Miquelon'],
    ['code' => 'VC', 'name' => 'Saint Vincent and the Grenadines'],
    ['code' => 'WS', 'name' => 'Samoa'],
    ['code' => 'SM', 'name' => 'San Marino'],
    ['code' => 'ST', 'name' => 'Sao Tome and Principe'],
    ['code' => 'SA', 'name' => 'Saudi Arabia'],
    ['code' => 'SN', 'name' => 'Senegal'],
    ['code' => 'RS', 'name' => 'Serbia'],
    ['code' => 'SC', 'name' => 'Seychelles'],
    ['code' => 'SL', 'name' => 'Sierra Leone'],
    ['code' => 'SG', 'name' => 'Singapore'],
    ['code' => 'SX', 'name' => 'Sint Maarten (Dutch part)'],
    ['code' => 'SK', 'name' => 'Slovakia'],
    ['code' => 'SI', 'name' => 'Slovenia'],
    ['code' => 'SB', 'name' => 'Solomon Islands'],
    ['code' => 'SO', 'name' => 'Somalia'],
    ['code' => 'ZA', 'name' => 'South Africa'],
    ['code' => 'GS', 'name' => 'South Georgia and the South Sandwich Islands'],
    ['code' => 'SS', 'name' => 'South Sudan'],
    ['code' => 'ES', 'name' => 'Spain'],
    ['code' => 'LK', 'name' => 'Sri Lanka'],
    ['code' => 'SD', 'name' => 'Sudan'],
    ['code' => 'SR', 'name' => 'Suriname'],
    ['code' => 'SJ', 'name' => 'Svalbard and Jan Mayen'],
    ['code' => 'SZ', 'name' => 'Swaziland'],
    ['code' => 'SE', 'name' => 'Sweden'],
    ['code' => 'CH', 'name' => 'Switzerland'],
    ['code' => 'SY', 'name' => 'Syrian Arab Republic'],
    ['code' => 'TW', 'name' => 'Taiwan, Province of China'],
    ['code' => 'TJ', 'name' => 'Tajikistan'],
    ['code' => 'TZ', 'name' => 'Tanzania, United Republic of'],
    ['code' => 'TH', 'name' => 'Thailand'],
    ['code' => 'TL', 'name' => 'Timor-Leste'],
    ['code' => 'TG', 'name' => 'Togo'],
    ['code' => 'TK', 'name' => 'Tokelau'],
    ['code' => 'TO', 'name' => 'Tonga'],
    ['code' => 'TT', 'name' => 'Trinidad and Tobago'],
    ['code' => 'TN', 'name' => 'Tunisia'],
    ['code' => 'TR', 'name' => 'Turkey'],
    ['code' => 'TM', 'name' => 'Turkmenistan'],
    ['code' => 'TC', 'name' => 'Turks and Caicos Islands'],
    ['code' => 'TV', 'name' => 'Tuvalu'],
    ['code' => 'UG', 'name' => 'Uganda'],
    ['code' => 'UA', 'name' => 'Ukraine'],
    ['code' => 'AE', 'name' => 'United Arab Emirates'],
    ['code' => 'GB', 'name' => 'United Kingdom'],
    ['code' => 'US', 'name' => 'United States'],
    ['code' => 'UM', 'name' => 'United States Minor Outlying Islands'],
    ['code' => 'UY', 'name' => 'Uruguay'],
    ['code' => 'UZ', 'name' => 'Uzbekistan'],
    ['code' => 'VU', 'name' => 'Vanuatu'],
    ['code' => 'VE', 'name' => 'Venezuela, Bolivarian Republic of'],
    ['code' => 'VN', 'name' => 'Viet Nam'],
    ['code' => 'VG', 'name' => 'Virgin Islands, British'],
    ['code' => 'VI', 'name' => 'Virgin Islands, U.S.'],
    ['code' => 'WF', 'name' => 'Wallis and Futuna'],
    ['code' => 'EH', 'name' => 'Western Sahara'],
    ['code' => 'YE', 'name' => 'Yemen'],
    ['code' => 'ZM', 'name' => 'Zambia'],
    ['code' => 'ZW', 'name' => 'Zimbabwe'],
];

const TIME_ZONE = [
    ['key' => 'Pacific/Midway', 'name' => '(UTC-11:00) Midway Island'],
    ['key' => 'Pacific/Samoa', 'name' => '(UTC-11:00) Samoa'],
    ['key' => 'Pacific/Honolulu', 'name' => '(UTC-10:00) Hawaii'],
    ['key' => 'US/Alaska', 'name' => '(UTC-09:00) Alaska'],
    ['key' => 'America/Los_Angeles', 'name' => '(UTC-08:00) Pacific Time (US & Canada)'],
    ['key' => 'America/Tijuana', 'name' => '(UTC-08:00) Tijuana'],
    ['key' => 'US/Arizona', 'name' => '(UTC-07:00) Arizona'],
    ['key' => 'America/Chihuahua', 'name' => '(UTC-07:00) Chihuahua'],
    ['key' => 'America/La_Paz', 'name' => '(UTC-07:00) La Paz'],
    ['key' => 'America/Mazatlan', 'name' => '(UTC-07:00) Mazatlan'],
    ['key' => 'US/Mountain', 'name' => '(UTC-07:00) Mountain Time (US & Canada)'],
    ['key' => 'America/Managua', 'name' => '(UTC-06:00) Central America'],
    ['key' => 'US/Central', 'name' => '(UTC-06:00) Central Time (US & Canada)'],
    ['key' => 'America/Mexico_City', 'name' => '(UTC-06:00) Guadalajara'],
    ['key' => 'America/Mexico_City', 'name' => '(UTC-06:00) Mexico City'],
    ['key' => 'America/Monterrey', 'name' => '(UTC-06:00) Monterrey'],
    ['key' => 'Canada/Saskatchewan', 'name' => '(UTC-06:00) Saskatchewan'],
    ['key' => 'America/Bogota', 'name' => '(UTC-05:00) Bogota'],
    ['key' => 'US/Eastern', 'name' => '(UTC-05:00) Eastern Time (US & Canada)'],
    ['key' => 'US/East-Indiana', 'name' => '(UTC-05:00) Indiana (East)'],
    ['key' => 'America/Lima', 'name' => '(UTC-05:00) Lima'],
    ['key' => 'America/Quito', 'name' => '(UTC-05:00) Quito'],
    ['key' => 'Canada/Atlantic', 'name' => '(UTC-04:00) Atlantic Time (Canada)'],
    ['key' => 'America/Caracas', 'name' => '(UTC-04:30) Caracas'],
    ['key' => 'America/La_Paz', 'name' => '(UTC-04:00) La Paz'],
    ['key' => 'America/Santiago', 'name' => '(UTC-04:00) Santiago'],
    ['key' => 'Canada/Newfoundland', 'name' => '(UTC-03:30) Newfoundland'],
    ['key' => 'America/Sao_Paulo', 'name' => '(UTC-03:00) Brasilia'],
    ['key' => 'America/Argentina/Buenos_Aires', 'name' => '(UTC-03:00) Buenos Aires'],
    ['key' => 'America/Argentina/Buenos_Aires', 'name' => '(UTC-03:00) Georgetown'],
    ['key' => 'America/Godthab', 'name' => '(UTC-03:00) Greenland'],
    ['key' => 'America/Noronha', 'name' => '(UTC-02:00) Mid-Atlantic'],
    ['key' => 'Atlantic/Azores', 'name' => '(UTC-01:00) Azores'],
    ['key' => 'Atlantic/Cape_Verde', 'name' => '(UTC-01:00) Cape Verde Is.'],
    ['key' => 'Africa/Casablanca', 'name' => '(UTC+00:00) Casablanca'],
    ['key' => 'Europe/London', 'name' => '(UTC+00:00) Edinburgh'],
    ['key' => 'Etc/Greenwich', 'name' => '(UTC+00:00) Greenwich Mean Time : Dublin'],
    ['key' => 'Europe/Lisbon', 'name' => '(UTC+00:00) Lisbon'],
    ['key' => 'Europe/London', 'name' => '(UTC+00:00) London'],
    ['key' => 'Africa/Monrovia', 'name' => '(UTC+00:00) Monrovia'],
    ['key' => 'UTC', 'name' => '(UTC+00:00) UTC'],
    ['key' => 'Europe/Amsterdam', 'name' => '(UTC+01:00) Amsterdam'],
    ['key' => 'Europe/Belgrade', 'name' => '(UTC+01:00) Belgrade'],
    ['key' => 'Europe/Berlin', 'name' => '(UTC+01:00) Berlin'],
    ['key' => 'Europe/Bern', 'name' => '(UTC+01:00) Bern'],
    ['key' => 'Europe/Bratislava', 'name' => '(UTC+01:00) Bratislava'],
    ['key' => 'Europe/Brussels', 'name' => '(UTC+01:00) Brussels'],
    ['key' => 'Europe/Budapest', 'name' => '(UTC+01:00) Budapest'],
    ['key' => 'Europe/Copenhagen', 'name' => '(UTC+01:00) Copenhagen'],
    ['key' => 'Europe/Ljubljana', 'name' => '(UTC+01:00) Ljubljana'],
    ['key' => 'Europe/Madrid', 'name' => '(UTC+01:00) Madrid'],
    ['key' => 'Europe/Paris', 'name' => '(UTC+01:00) Paris'],
    ['key' => 'Europe/Prague', 'name' => '(UTC+01:00) Prague'],
    ['key' => 'Europe/Rome', 'name' => '(UTC+01:00) Rome'],
    ['key' => 'Europe/Sarajevo', 'name' => '(UTC+01:00) Sarajevo'],
    ['key' => 'Europe/Skopje', 'name' => '(UTC+01:00) Skopje'],
    ['key' => 'Europe/Stockholm', 'name' => '(UTC+01:00) Stockholm'],
    ['key' => 'Europe/Vienna', 'name' => '(UTC+01:00) Vienna'],
    ['key' => 'Europe/Warsaw', 'name' => '(UTC+01:00) Warsaw'],
    ['key' => 'Africa/Lagos', 'name' => '(UTC+01:00) West Central Africa'],
    ['key' => 'Europe/Zagreb', 'name' => '(UTC+01:00) Zagreb'],
    ['key' => 'Europe/Athens', 'name' => '(UTC+02:00) Athens'],
    ['key' => 'Europe/Bucharest', 'name' => '(UTC+02:00) Bucharest'],
    ['key' => 'Africa/Cairo', 'name' => '(UTC+02:00) Cairo'],
    ['key' => 'Africa/Harare', 'name' => '(UTC+02:00) Harare'],
    ['key' => 'Europe/Helsinki', 'name' => '(UTC+02:00) Helsinki'],
    ['key' => 'Europe/Istanbul', 'name' => '(UTC+02:00) Istanbul'],
    ['key' => 'Asia/Jerusalem', 'name' => '(UTC+02:00) Jerusalem'],
    ['key' => 'Europe/Helsinki', 'name' => '(UTC+02:00) Kyiv'],
    ['key' => 'Africa/Johannesburg', 'name' => '(UTC+02:00) Pretoria'],
    ['key' => 'Europe/Riga', 'name' => '(UTC+02:00) Riga'],
    ['key' => 'Europe/Sofia', 'name' => '(UTC+02:00) Sofia'],
    ['key' => 'Europe/Tallinn', 'name' => '(UTC+02:00) Tallinn'],
    ['key' => 'Europe/Vilnius', 'name' => '(UTC+02:00) Vilnius'],
    ['key' => 'Asia/Baghdad', 'name' => '(UTC+03:00) Baghdad'],
    ['key' => 'Asia/Kuwait', 'name' => '(UTC+03:00) Kuwait'],
    ['key' => 'Europe/Minsk', 'name' => '(UTC+03:00) Minsk'],
    ['key' => 'Africa/Nairobi', 'name' => '(UTC+03:00) Nairobi'],
    ['key' => 'Asia/Riyadh', 'name' => '(UTC+03:00) Riyadh'],
    ['key' => 'Europe/Volgograd', 'name' => '(UTC+03:00) Volgograd'],
    ['key' => 'Asia/Tehran', 'name' => '(UTC+03:30) Tehran'],
    ['key' => 'Asia/Muscat', 'name' => '(UTC+04:00) Abu Dhabi'],
    ['key' => 'Asia/Baku', 'name' => '(UTC+04:00) Baku'],
    ['key' => 'Europe/Moscow', 'name' => '(UTC+04:00) Moscow'],
    ['key' => 'Asia/Muscat', 'name' => '(UTC+04:00) Muscat'],
    ['key' => 'Europe/Moscow', 'name' => '(UTC+04:00) St. Petersburg'],
    ['key' => 'Asia/Tbilisi', 'name' => '(UTC+04:00) Tbilisi'],
    ['key' => 'Asia/Yerevan', 'name' => '(UTC+04:00) Yerevan'],
    ['key' => 'Asia/Kabul', 'name' => '(UTC+04:30) Kabul'],
    ['key' => 'Asia/Karachi', 'name' => '(UTC+05:00) Islamabad'],
    ['key' => 'Asia/Karachi', 'name' => '(UTC+05:00) Karachi'],
    ['key' => 'Asia/Tashkent', 'name' => '(UTC+05:00) Tashkent'],
    ['key' => 'Asia/Calcutta', 'name' => '(UTC+05:30) Chennai'],
    ['key' => 'Asia/Kolkata', 'name' => '(UTC+05:30) Kolkata'],
    ['key' => 'Asia/Calcutta', 'name' => '(UTC+05:30) Mumbai'],
    ['key' => 'Asia/Calcutta', 'name' => '(UTC+05:30) New Delhi'],
    ['key' => 'Asia/Calcutta', 'name' => '(UTC+05:30) Sri Jayawardenepura'],
    ['key' => 'Asia/Katmandu', 'name' => '(UTC+05:45) Kathmandu'],
    ['key' => 'Asia/Almaty', 'name' => '(UTC+06:00) Almaty'],
    ['key' => 'Asia/Dhaka', 'name' => '(UTC+06:00) Dhaka'],
    ['key' => 'Asia/Yekaterinburg', 'name' => '(UTC+06:00) Ekaterinburg'],
    ['key' => 'Asia/Rangoon', 'name' => '(UTC+06:30) Rangoon'],
    ['key' => 'Asia/Bangkok', 'name' => '(UTC+07:00) Bangkok'],
    ['key' => 'Asia/Bangkok', 'name' => '(UTC+07:00) Hanoi'],
    ['key' => 'Asia/Jakarta', 'name' => '(UTC+07:00) Jakarta'],
    ['key' => 'Asia/Novosibirsk', 'name' => '(UTC+07:00) Novosibirsk'],
    ['key' => 'Asia/Hong_Kong', 'name' => '(UTC+08:00) Beijing'],
    ['key' => 'Asia/Chongqing', 'name' => '(UTC+08:00) Chongqing'],
    ['key' => 'Asia/Hong_Kong', 'name' => '(UTC+08:00) Hong Kong'],
    ['key' => 'Asia/Krasnoyarsk', 'name' => '(UTC+08:00) Krasnoyarsk'],
    ['key' => 'Asia/Kuala_Lumpur', 'name' => '(UTC+08:00) Kuala Lumpur'],
    ['key' => 'Australia/Perth', 'name' => '(UTC+08:00) Perth'],
    ['key' => 'Asia/Singapore', 'name' => '(UTC+08:00) Singapore'],
    ['key' => 'Asia/Taipei', 'name' => '(UTC+08:00) Taipei'],
    ['key' => 'Asia/Ulan_Bator', 'name' => '(UTC+08:00) Ulaan Bataar'],
    ['key' => 'Asia/Urumqi', 'name' => '(UTC+08:00) Urumqi'],
    ['key' => 'Asia/Irkutsk', 'name' => '(UTC+09:00) Irkutsk'],
    ['key' => 'Asia/Tokyo', 'name' => '(UTC+09:00) Osaka'],
    ['key' => 'Asia/Tokyo', 'name' => '(UTC+09:00) Sapporo'],
    ['key' => 'Asia/Seoul', 'name' => '(UTC+09:00) Seoul'],
    ['key' => 'Asia/Tokyo', 'name' => '(UTC+09:00) Tokyo'],
    ['key' => 'Australia/Adelaide', 'name' => '(UTC+09:30) Adelaide'],
    ['key' => 'Australia/Darwin', 'name' => '(UTC+09:30) Darwin'],
    ['key' => 'Australia/Brisbane', 'name' => '(UTC+10:00) Brisbane'],
    ['key' => 'Australia/Canberra', 'name' => '(UTC+10:00) Canberra'],
    ['key' => 'Pacific/Guam', 'name' => '(UTC+10:00) Guam'],
    ['key' => 'Australia/Hobart', 'name' => '(UTC+10:00) Hobart'],
    ['key' => 'Australia/Melbourne', 'name' => '(UTC+10:00) Melbourne'],
    ['key' => 'Pacific/Port_Moresby', 'name' => '(UTC+10:00) Port Moresby'],
    ['key' => 'Australia/Sydney', 'name' => '(UTC+10:00) Sydney'],
    ['key' => 'Asia/Yakutsk', 'name' => '(UTC+09:00) Yakutsk'],
    ['key' => 'Asia/Vladivostok', 'name' => '(UTC+10:00) Vladivostok'],
    ['key' => 'Pacific/Auckland', 'name' => '(UTC+12:00) Auckland'],
    ['key' => 'Pacific/Fiji', 'name' => '(UTC+12:00) Fiji'],
    ['key' => 'Pacific/Kwajalein', 'name' => '(UTC+12:00) International Date Line West'],
    ['key' => 'Asia/Kamchatka', 'name' => '(UTC+12:00) Kamchatka'],
    ['key' => 'Asia/Magadan', 'name' => '(UTC+12:00) Magadan'],
    ['key' => 'Pacific/Fiji', 'name' => '(UTC+12:00) Marshall Is.'],
    ['key' => 'Asia/Magadan', 'name' => '(UTC+12:00) Solomon Is.'],
    ['key' => 'Pacific/Auckland', 'name' => '(UTC+12:00) Wellington'],
    ['key' => 'Pacific/Tongatapu', 'name' => '(UTC+13:00) Nuku\'alofa'],
];


const LANGUAGE_CODE = [
    ['code' => 'en', 'name' => 'English (default)'],
    ['code' => 'af', 'name' => 'Afrikaans'],
    ['code' => 'sq', 'name' => 'Albanian - shqip'],
    ['code' => 'am', 'name' => 'Amharic - አማርኛ'],
    ['code' => 'ar', 'name' => 'Arabic - العربية'],
    ['code' => 'an', 'name' => 'Aragonese - aragonés'],
    ['code' => 'hy', 'name' => 'Armenian - հայերեն'],
    ['code' => 'ast', 'name' => 'Asturian - asturianu'],
    ['code' => 'az', 'name' => 'Azerbaijani - azərbaycan dili'],
    ['code' => 'eu', 'name' => 'Basque - euskara'],
    ['code' => 'be', 'name' => 'Belarusian - беларуская'],
    ['code' => 'bn', 'name' => 'Bengali - বাংলা'],
    ['code' => 'bs', 'name' => 'Bosnian - bosanski'],
    ['code' => 'br', 'name' => 'Breton - brezhoneg'],
    ['code' => 'bg', 'name' => 'Bulgarian - български'],
    ['code' => 'ca', 'name' => 'Catalan - català'],
    ['code' => 'ckb', 'name' => 'Central Kurdish - کوردی (دەستنوسی عەرەبی)'],
    ['code' => 'zh', 'name' => 'Chinese - 中文'],
    ['code' => 'zh-HK', 'name' => 'Chinese (Hong Kong) - 中文（香港）'],
    ['code' => 'zh-CN', 'name' => 'Chinese (Simplified) - 中文（简体）'],
    ['code' => 'zh-TW', 'name' => 'Chinese (Traditional) - 中文（繁體）'],
    ['code' => 'co', 'name' => 'Corsican'],
    ['code' => 'hr', 'name' => 'Croatian - hrvatski'],
    ['code' => 'cs', 'name' => 'Czech - čeština'],
    ['code' => 'da', 'name' => 'Danish - dansk'],
    ['code' => 'nl', 'name' => 'Dutch - Nederlands'],
    ['code' => 'en-AU', 'name' => 'English (Australia)'],
    ['code' => 'en-CA', 'name' => 'English (Canada)'],
    ['code' => 'en-IN', 'name' => 'English (India)'],
    ['code' => 'en-NZ', 'name' => 'English (New Zealand)'],
    ['code' => 'en-ZA', 'name' => 'English (South Africa)'],
    ['code' => 'en-GB', 'name' => 'English (United Kingdom)'],
    ['code' => 'en-US', 'name' => 'English (United States)'],
    ['code' => 'eo', 'name' => 'Esperanto - esperanto'],
    ['code' => 'et', 'name' => 'Estonian - eesti'],
    ['code' => 'fo', 'name' => 'Faroese - føroyskt'],
    ['code' => 'fil', 'name' => 'Filipino'],
    ['code' => 'fi', 'name' => 'Finnish - suomi'],
    ['code' => 'fr', 'name' => 'French - français'],
    ['code' => 'fr-CA', 'name' => 'French (Canada) - français (Canada)'],
    ['code' => 'fr-FR', 'name' => 'French (France) - français (France)'],
    ['code' => 'fr-CH', 'name' => 'French (Switzerland) - français (Suisse)'],
    ['code' => 'gl', 'name' => 'Galician - galego'],
    ['code' => 'ka', 'name' => 'Georgian - ქართული'],
    ['code' => 'de', 'name' => 'German - Deutsch'],
    ['code' => 'de-AT', 'name' => 'German (Austria) - Deutsch (Österreich)'],
    ['code' => 'de-DE', 'name' => 'German (Germany) - Deutsch (Deutschland)'],
    ['code' => 'de-LI', 'name' => 'German (Liechtenstein) - Deutsch (Liechtenstein)'],
    ['code' => 'de-CH', 'name' => 'German (Switzerland) - Deutsch (Schweiz)'],
    ['code' => 'el', 'name' => 'Greek - Ελληνικά'],
    ['code' => 'gn', 'name' => 'Guarani'],
    ['code' => 'gu', 'name' => 'Gujarati - ગુજરાતી'],
    ['code' => 'ha', 'name' => 'Hausa'],
    ['code' => 'haw', 'name' => 'Hawaiian - ʻŌlelo Hawaiʻi'],
    ['code' => 'he', 'name' => 'Hebrew - עברית'],
    ['code' => 'hi', 'name' => 'Hindi - हिन्दी'],
    ['code' => 'hu', 'name' => 'Hungarian - magyar'],
    ['code' => 'is', 'name' => 'Icelandic - íslenska'],
    ['code' => 'id', 'name' => 'Indonesian - Indonesia'],
    ['code' => 'ia', 'name' => 'Interlingua'],
    ['code' => 'ga', 'name' => 'Irish - Gaeilge'],
    ['code' => 'it', 'name' => 'Italian - italiano'],
    ['code' => 'it-IT', 'name' => 'Italian (Italy) - italiano (Italia)'],
    ['code' => 'it-CH', 'name' => 'Italian (Switzerland) - italiano (Svizzera)'],
    ['code' => 'ja', 'name' => 'Japanese - 日本語'],
    ['code' => 'kn', 'name' => 'Kannada - ಕನ್ನಡ'],
    ['code' => 'kk', 'name' => 'Kazakh - қазақ тілі'],
    ['code' => 'km', 'name' => 'Khmer - ខ្មែរ'],
    ['code' => 'ko', 'name' => 'Korean - 한국어'],
    ['code' => 'ku', 'name' => 'Kurdish - Kurdî'],
    ['code' => 'ky', 'name' => 'Kyrgyz - кыргызча'],
    ['code' => 'lo', 'name' => 'Lao - ລາວ'],
    ['code' => 'la', 'name' => 'Latin'],
    ['code' => 'lv', 'name' => 'Latvian - latviešu'],
    ['code' => 'ln', 'name' => 'Lingala - lingála'],
    ['code' => 'lt', 'name' => 'Lithuanian - lietuvių'],
    ['code' => 'mk', 'name' => 'Macedonian - македонски'],
    ['code' => 'ms', 'name' => 'Malay - Bahasa Melayu'],
    ['code' => 'ml', 'name' => 'Malayalam - മലയാളം'],
    ['code' => 'mt', 'name' => 'Maltese - Malti'],
    ['code' => 'mr', 'name' => 'Marathi - मराठी'],
    ['code' => 'mn', 'name' => 'Mongolian - монгол'],
    ['code' => 'ne', 'name' => 'Nepali - नेपाली'],
    ['code' => 'no', 'name' => 'Norwegian - norsk'],
    ['code' => 'nb', 'name' => 'Norwegian Bokmål - norsk bokmål'],
    ['code' => 'nn', 'name' => 'Norwegian Nynorsk - nynorsk'],
    ['code' => 'oc', 'name' => 'Occitan'],
    ['code' => 'or', 'name' => 'Oriya - ଓଡ଼ିଆ'],
    ['code' => 'om', 'name' => 'Oromo - Oromoo'],
    ['code' => 'ps', 'name' => 'Pashto - پښتو'],
    ['code' => 'fa', 'name' => 'Persian - فارسی'],
    ['code' => 'pl', 'name' => 'Polish - polski'],
    ['code' => 'pt', 'name' => 'Portuguese - português'],
    ['code' => 'pt-BR', 'name' => 'Portuguese (Brazil) - português (Brasil)'],
    ['code' => 'pt-PT', 'name' => 'Portuguese (Portugal) - português (Portugal)'],
    ['code' => 'pa', 'name' => 'Punjabi - ਪੰਜਾਬੀ'],
    ['code' => 'qu', 'name' => 'Quechua'],
    ['code' => 'ro', 'name' => 'Romanian - română'],
    ['code' => 'mo', 'name' => 'Romanian (Moldova) - română (Moldova)'],
    ['code' => 'rm', 'name' => 'Romansh - rumantsch'],
    ['code' => 'ru', 'name' => 'Russian - русский'],
    ['code' => 'gd', 'name' => 'Scottish Gaelic'],
    ['code' => 'sr', 'name' => 'Serbian - српски'],
    ['code' => 'sh', 'name' => 'Serbo-Croatian - Srpskohrvatski'],
    ['code' => 'sn', 'name' => 'Shona - chiShona'],
    ['code' => 'sd', 'name' => 'Sindhi'],
    ['code' => 'si', 'name' => 'Sinhala - සිංහල'],
    ['code' => 'sk', 'name' => 'Slovak - slovenčina'],
    ['code' => 'sl', 'name' => 'Slovenian - slovenščina'],
    ['code' => 'so', 'name' => 'Somali - Soomaali'],
    ['code' => 'st', 'name' => 'Southern Sotho'],
    ['code' => 'es', 'name' => 'Spanish - español'],
    ['code' => 'es-AR', 'name' => 'Spanish (Argentina) - español (Argentina)'],
    ['code' => 'es-419', 'name' => 'Spanish (Latin America) - español (Latinoamérica)'],
    ['code' => 'es-MX', 'name' => 'Spanish (Mexico) - español (México)'],
    ['code' => 'es-ES', 'name' => 'Spanish (Spain) - español (España)'],
    ['code' => 'es-US', 'name' => 'Spanish (United States) - español (Estados Unidos)'],
    ['code' => 'su', 'name' => 'Sundanese'],
    ['code' => 'sw', 'name' => 'Swahili - Kiswahili'],
    ['code' => 'sv', 'name' => 'Swedish - svenska'],
    ['code' => 'tg', 'name' => 'Tajik - тоҷикӣ'],
    ['code' => 'ta', 'name' => 'Tamil - தமிழ்'],
    ['code' => 'tt', 'name' => 'Tatar'],
    ['code' => 'te', 'name' => 'Telugu - తెలుగు'],
    ['code' => 'th', 'name' => 'Thai - ไทย'],
    ['code' => 'ti', 'name' => 'Tigrinya - ትግርኛ'],
    ['code' => 'to', 'name' => 'Tongan - lea fakatonga'],
    ['code' => 'tr', 'name' => 'Turkish - Türkçe'],
    ['code' => 'tk', 'name' => 'Turkmen'],
    ['code' => 'tw', 'name' => 'Twi'],
    ['code' => 'uk', 'name' => 'Ukrainian - українська'],
    ['code' => 'ur', 'name' => 'Urdu - اردو'],
    ['code' => 'ug', 'name' => 'Uyghur'],
    ['code' => 'uz', 'name' => 'Uzbek - o‘zbek'],
    ['code' => 'vi', 'name' => 'Vietnamese - Tiếng Việt'],
    ['code' => 'wa', 'name' => 'Walloon - wa'],
    ['code' => 'cy', 'name' => 'Welsh - Cymraeg'],
    ['code' => 'fy', 'name' => 'Western Frisian'],
    ['code' => 'xh', 'name' => 'Xhosa'],
    ['code' => 'yi', 'name' => 'Yiddish'],
    ['code' => 'yo', 'name' => 'Yoruba - Èdè Yorùbá'],
    ['code' => 'zu', 'name' => 'Zulu - isiZulu'],
];
